/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.category;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.IEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EnderCrafterCategory
implements IRecipeCategory<IEnderCrafterRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("extendedcrafting", "textures/gui/jei/ender_crafting.png");
    public static final ResourceLocation UID = new ResourceLocation("extendedcrafting", "ender_crafting");
    private final IDrawable background;
    private final IDrawableAnimated arrow;
    private final IDrawable icon;

    public EnderCrafterCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 116, 54);
        IDrawableStatic arrowDrawable = helper.createDrawable(TEXTURE, 195, 0, 24, 17);
        this.arrow = helper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.ENDER_CRAFTER.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends IEnderCrafterRecipe> getRecipeClass() {
        return IEnderCrafterRecipe.class;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.ender_crafting").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IEnderCrafterRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 61, 19);
    }

    public List<Component> getTooltipStrings(IEnderCrafterRecipe recipe, double mouseX, double mouseY) {
        if (mouseX > 60.0 && mouseX < 83.0 && mouseY > 19.0 && mouseY < 34.0) {
            return Collections.singletonList(ModTooltips.SECONDS.args(new Object[]{recipe.getCraftingTime()}).color(ChatFormatting.WHITE).build());
        }
        return Collections.emptyList();
    }

    public void setIngredients(IEnderCrafterRecipe recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
        ingredients.setInputIngredients((List)recipe.m_7527_());
    }

    public void setRecipe(IRecipeLayout layout, IEnderCrafterRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0);
        stacks.init(0, false, 94, 18);
        stacks.set(0, outputs);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = 1 + j + i * 3;
                stacks.init(index, true, j * 18, i * 18);
            }
        }
        if (recipe instanceof ShapedEnderCrafterRecipe) {
            ShapedEnderCrafterRecipe shaped = (ShapedEnderCrafterRecipe)recipe;
            int stackIndex = 0;
            for (int i = 0; i < shaped.getHeight(); ++i) {
                for (int j = 0; j < shaped.getWidth(); ++j) {
                    int index = 1 + i * 3 + j;
                    stacks.set(index, (List)inputs.get(stackIndex));
                    ++stackIndex;
                }
            }
        } else if (recipe instanceof ShapelessEnderCrafterRecipe) {
            for (int i = 0; i < inputs.size(); ++i) {
                stacks.set(i + 1, (List)inputs.get(i));
            }
            layout.setShapeless();
        }
        layout.moveRecipeTransferButton(122, 41);
    }
}

